@extends('backoffice.layouts.main')

@section('content')
<div class="card mt-3">
    <div class="card-header">
        Pengaturan Tampilan Website
    </div>
    <div class="card-body">
        <form action="{{ route('setting.update', $setting->id) }}" method="POST" enctype="multipart/form-data">
            @method('PUT')
            @csrf
            <label for="">Info Website</label>
            <div class="row">
                <div class="col-6">
                    <div class="form-group">
                        <label for="exampleInputEmail1" class="form-text text-muted">Nama Website :</label>
                        <input name="nama_web" type="text" class="form-control" placeholder="Nama Website"
                            value="{{ $setting->nama_web }}">
                    </div>
                </div>
                <div class="col-6">
                    <div class="form-group">
                        <label class="form-text text-muted">No TLP:</label>
                        <input name="telp" type="number" class="form-control" placeholder="Nomor Telepon format +62"
                            value="{{ $setting->telp }}">
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-6">
                    <div class="form-group">
                        <label for="exampleInputEmail1" class="form-text text-muted">SEO Meta Keyword :</label>
                        <input name="metaKeyword" type="text" class="form-control" placeholder=""
                            value="{{ $setting->seo_meta_keywords }}">
                    </div>
                </div>
                <div class="col-6">
                    <div class="form-group">
                        <label for="exampleInputEmail1" class="form-text text-muted">SEO Description :</label>
                        <input name="metaDescription" type="text" class="form-control" placeholder=""
                            value="{{ $setting->seo_description }}">
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-6">
                    <div class="form-group">
                        <label for="exampleInputEmail1" class="form-text text-muted">SEO Social Meta Description :</label>
                        <input name="metaSocial" type="text" class="form-control" placeholder=""
                            value="{{ $setting->seo_social_description }}">
                    </div>
                </div>
            </div>
            <hr style="border: 2px solid rgb(208, 255, 0)">
            <label for="">Kontak (Whatsapp, Telegram, dll)</label>
            <div class="row">
                <div class="col-6">
                    <div class="form-group">
                        <label class="form-text text-muted">No Whatsapp :</label>
                        <input name="wa" type="text" class="form-control" value="{{ $setting->wa }}"
                            placeholder="Nomor Whatsapp format +62">
                    </div>
                </div>
                <div class="col-6">
                    <div class="form-group">
                        <label class="form-text text-muted">Username Telegram :</label>
                        <input name="tele" type="text" class="form-control" value="{{ $setting->tele }}"
                            placeholder="Username Telegram">
                    </div>
                </div>
                <div class="col-12">
                    <div class="form-group">
                        <label for="exampleInputEmail1" class="form-text text-muted">Live Chat :</label>
                        <textarea name="live_chat" type="text" class="form-control" placeholder="Live Chat">{{ $setting->live_chat }}</textarea>
                    </div>
                </div>
            </div>
            <hr style="border: 2px solid rgb(208, 255, 0)">
            <label for="">Tampilan Website</label>
            <div class="row">
                <div class="col-6">
                    <div class="row">
                        <div class="col-10">
                            <label class="form-text text-muted">Logo Website :</label>
                            <input name="logo" type="file" class="form-control uploads" accept="image/png, image/jpeg, image/gif, video/mp4">
                        </div>
                        <div class="col-10">
                            <label class="form-text text-muted">Pop Up Banner :</label>
                            <input name="popup" type="file" class="form-control uploads" accept="image/png, image/jpeg, image/gif, video/mp4">
                        </div>
                    </div>
                </div>
                <div class="col-6">
                    <div class="form-group">
                        <label class="form-text text-muted">Running Text :</label>
                        <input name="running_text" type="text" class="form-control"
                            value="{{ $setting->running_text }}" placeholder="Running Text">
                    </div>
                </div>
            </div>
            <hr style="border: 2px solid rgb(208, 255, 0)">
            <label for="">Tampilan</label>
            <div class="row">
                <div class="col-12">
                    <div class="form-group">
                        <label for="exampleInputEmail1" class="form-text text-muted">Maintenance :</label>
                        <input type="checkbox" name="maintenance_mode" value="1"
                            <?= $setting->maintenance_mode == 1 ? 'checked' : '' ?>>
                    </div>
                </div>
                <div class="col-6">
                    <div class="form-group">
                        <label for="exampleInputEmail1" class="form-text text-muted">Template :</label>
                        <select name="template" class="form-control">
                            <option value="main" <?= $setting->template == 'main' ? 'selected' : '' ?>>Onix/UG
                            </option>
                        </select>
                    </div>
                </div>
                <div class="col-6">
                    <div class="form-group">
                        <label for="Theme" class="form-text text-muted">Theme :</label>
                        <select name="theme" class="form-control">
                            <option value="{{ $setting->themes }}">{{ $setting->themes }}</option>
                            <option value="theme-1">
                                Onix Theme
                            </option>
                            <option value="theme-2">
                                Onix Theme 2
                            </option>
                            <option value="theme-3">
                                Onix Theme 3
                            </option>
                            <option value="theme-4">
                                Onix Theme 4
                            </option>
                            <option value="theme-5">
                                Onix Theme 5
                            </option>
                            <option value="theme-6">
                                Onix Theme 6
                            </option>
                            <option value="theme-7">
                                Onix Theme 7
                            </option>
                            <option value="theme-8">
                                Onix Theme 8
                            </option>
                            <option value="theme-9">
                                Onix Theme 9
                            </option>
                            <option value="theme-10">
                                Onix Theme 10
                            </option>
                            <option value="theme-11">
                                Onix Theme 11
                            </option>
                            <option value="theme-12">
                                Onix Theme 12
                            </option>
                            <option value="theme-13">
                                Onix Theme 13
                            </option>
                            <option value="theme-14">
                                Onix Theme 14
                            </option>
                            <option value="theme-15">
                                Onix Theme 15
                            </option>
                            <option value="theme-16">
                                Onix Theme 16
                            </option>
                            <option value="theme-17">
                                Onix Theme 17
                            </option>
                            <option value="theme-18">
                                Onix Theme 18
                            </option>
                            <option value="theme-19">
                                Onix Theme 19
                            </option>
                            <option value="theme-20">
                                Onix Theme 20
                            </option>
                            <option value="theme-21">
                                Onix Theme 21
                            </option>
                            <option value="theme-22">
                                Onix Theme 22
                            </option>
                            <option value="theme-23">
                                Onix Theme 23
                            </option>
                            <option value="theme-24">
                                Onix Theme 24
                            </option>
                            <option value="theme-25">
                                Onix Theme 25
                            </option>
                            <option value="theme-26">
                                Onix Theme 26
                            </option>
                            <option value="theme-27">
                                Onix Theme 27
                            </option>
                            <option value="theme-28">
                                Onix Theme 28
                            </option>
                            <option value="theme-29">
                                Onix Theme 29
                            </option>
                            <option value="theme-30">
                                Onix Theme 30
                            </option>
                        </select>
                    </div>
                </div>
                <div class="col-6">
                    <div class="form-group">
                        <label for="exampleInputEmail1" class="form-text text-muted">Popup Text :</label>
                        <textarea id="editor" name="msg_popup">
                            {{ $setting->msg_popup }}
                        </textarea>
                    </div>
                </div>
                <div class="form-group">
                    <label for="exampleInputEmail1" class="form-text text-muted">PopUp Background :</label>
                    <input type="color" value="{{$setting->popup_bg}}" name="popup_bg">
                </div>
            </div>
            
            <br>
            <button type="submit" class="btn btn-primary">Update</button>
        </form>
    </div>
</div>

@endsection